@extends('layouts.admin')

@section('title', 'View Doctor')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Doctor Details</h1>
    <div>
        <a href="{{ route('admin.doctors.edit', $doctor) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.doctors.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4 text-center">
                @if($doctor->image)
                    <img src="{{ asset('storage/' . $doctor->image) }}" alt="{{ $doctor->name }}" class="img-fluid rounded mb-3" style="max-width: 300px;">
                @else
                    <i class="bi bi-person-circle" style="font-size: 200px; color: #ccc;"></i>
                @endif
            </div>
            <div class="col-md-8">
                <h2>{{ $doctor->name }}</h2>
                <p class="text-primary fs-5"><strong>{{ $doctor->specialization }}</strong></p>
                <p class="text-muted">{{ $doctor->credentials }}</p>
                @if($doctor->bio)
                <p>{{ $doctor->bio }}</p>
                @endif
                <p><strong>Experience:</strong> {{ $doctor->experience_years }} years</p>
                <p>
                    <strong>Status:</strong> 
                    <span class="badge bg-{{ $doctor->is_active ? 'success' : 'secondary' }}">
                        {{ $doctor->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection



